import { Swiper, pop, activeUser, appSounds, Notif, setPrintHeader, Trail, currency, ENDPOINTS } from './utils.js'
import { DateTime } from '../plugins/luxon.js'
import { TabulatorFull as Tabulator } from '/assets/plugins/tabulator/js/tabulator_esm.min.js'
import myAlertfyDialog from '../../components/myAlertifyDialog.js';
import StoresList from '/shared/StoreList.js';
import { RTF } from '/shared/helpers.js';
import { DOC_PRINT_HEADING, UploadDir } from '../../shared/helpers.js';
// import { crudMyAccount } from '../../components/crudMyAccount.js';

// BIND notif variable to the Global scope(window)   
window.Notif = Notif;

window.userRights;
window.pageRights;

try {
    if('serviceWorker' in navigator) {
        // navigator.serviceWorker.register('/sw.js')
        // .then(function() { console.log("Service Worker Registered"); })
        // .catch(error => console.error("Ooppsss.."));
    }   
    // else{
    //     alert("Your Browser does not support Service Workers");
    // } 
} catch (error) {
    console.error(error);
}

// init new swiper for Main NavBar 
const swiper = new Swiper('.swiper#navMenuSwiper', {
    speed: 400,
    autoHeight: false,
    // spaceBetween: 100,
    // Responsive breakpoints
    initialSlide: location.pathname != '/' && $("#header #navMenuSwiper .swiper-slide.active").index(),
    breakpoints: {
        // when window width is >= 480px
        480: {
            slidesPerView: 2,
            // spaceBetween: 30
        },
        // when window width is >= 640px
        640: {
            slidesPerView: 3,
            // spaceBetween: 40
        },
        768: {
            slidesPerView: 3,
            // spaceBetween: 40
        },
        957: {
            slidesPerView: 4,
            // spaceBetween: 40
        },
        1280: {
            slidesPerView: 6,
            // spaceBetween: 40
        }
        
    },
    on: {
        init: swiper => {
            // console.log(swiper);
            // alert('init')
            // activeUser && Trail.log({ act: 'Navigation', user: activeUser.id, notes: `Visited to ${swiper.params.direction} direction of ${swiper.swipeDirection == "next" ? 'right' : 'left'}` })
        },
        // slideChange: swiper => {
        //     console.log(swiper);
        //     Trail.log({ act: 'Navigation', user: activeUser.id, notes: `Visited to ${swiper.params.direction} direction of ${swiper.swipeDirection == "next" ? 'right' : 'left'}` })
        // }
        click: swiper => {
            // console.log(swiper)
        }
    }
}); 

const companyProfile = await(await pop(ENDPOINTS.org)).data

let staffBioData, user;
const checkUserRights = async params => {
    // console.log("checkUserRights Params: ", params)
    const { currentUser, routeTo, override } = params
    if($(document.body).data('page') != 'login') {
        if(_.isNull(currentUser)){
            Logout()
            return;
        }
        const resp = await pop(`/staff/crud.php?pop&one&emp_id=${activeUser.id}`), { rights } = resp.data[0], { access } = authuser({ rights, currentUser, routeTo });
        if(!access){
            alertify.alert("Access Denied!!!", `<h1 class='text-danger' style="font-size: 1.3em; margin: 0;">You do not have sufficient rights to access the <samp style="color: #eee; text-shadow: 2px 2px 1px #f05;">${_.startCase(routeTo)}</samp> page.</h1><br/>Please contact your System Administrator.`).set({ 'frameless': _.isUndefined(override) ? true : false, 'closable': !(override) ? false : true });
            const sto = _.isUndefined(override) && setTimeout(() => { clearTimeout(sto); history.go(-1); }, 3000);
        }
        localStorage.setItem('userRights', rights);
        return access;
    } 
},
authuser = params => {
    // console.log("authuser Params: ", params)
    let { routeTo } = params, rights = JSON.parse(params.rights);
    return { access: _.has(rights, routeTo) && rights[routeTo][`view_${routeTo}`], rights };
},
Logout = e => {
    Trail.log({ act: 'logout', user: activeUser?.id })
    localStorage.removeItem('authUser');
    window.location.href = `/logout.php?back=${location.pathname}`;
},
AccessRights = async () => {
    // console.log(JSON.parse(localStorage.getItem('userRights')))
    const userRights = JSON.parse(localStorage.getItem('userRights')),
    pageRights = (!_.isNull(localStorage.getItem('userRights')) && $(document.body).data('page') != 'login') && JSON.parse(localStorage.getItem('userRights'))[_.split(location.pathname, '/')[1]]
    const obj = { userRights, pageRights }
    window.userRights = userRights
    window.pageRights = pageRights
    // console.log({obj})
    return obj
}

// CHECK USER RIGHTS ON PAGE LOAD
await checkUserRights({ currentUser: activeUser, routeTo: _.split(location.pathname, '/')[1] });
await AccessRights();

$("#navMenu .sidebar-nav .nav-item").on('click', async e => {
    e.preventDefault()
    // console.log($(e.target).closest('a').prop('href'))
    if($(e.target).closest('a').prop('href')){
        const routeTo = _.split($(e.target).closest('a')[0].pathname, '/')[1], activeURI = $(e.target).closest('a').hasClass('active'), access = await checkUserRights({ currentUser: activeUser, routeTo, override: false });
        if(access) return !activeURI ? location.href = $(e.target).closest('a')[0].href : ''
    }
})

if(location.pathname != "/"){ 
    var isLoggedin = setInterval(() => {
        // console.log(location)
        if ((!localStorage.getItem('authUser') || localStorage.getItem('authUser') == null)) {
            // console.log(localStorage.getItem('authUser'))
            clearInterval(isLoggedin);
            Logout();
        }
    }, 500);

    // $('.ui.dropdown').dropdown();

    // $("header div:last").find("img").prop('src', `${UploadDir.staff}/${activeUser.photo}`)
    // const photo = await (await fetch(`${UploadDir.staff}/${activeUser.photo}`)).blob();
    // console.log(typeof photo)
    
    if(activeUser){
        $("header div:last-child menu section:first-child small").html(`
        <span style="display: flex; gap: 10px; text-align: center; width: 100%; padding: 0 10px;">
            
            <small><i class="fa fa-circle clr-lime"></i> ${_.startCase(activeUser.name)}</small>
        </span>`)
        .parents('div').find("img").prop('src', `${UploadDir.staff}/${activeUser.photo}`).closest('menu section:first-child').append(`<a href="javascript:void(0);" id="btnUpdateProfile" style="width: unset; position: absolute; top: 5px; right: 10px; padding: 5px;" class="bg-default"><i class="fa fa-edit" style="padding: 5px;"></i></a>`)
    
        $("#btnUpdateProfile").on('click', async e => {
            await crudMyAccount({ e })        
        })
    }

    if(navigator.onLine) {
        // console.log("You are online");
        alertify.success("You are online!", "<div class='text-danger'>You are back online."); 
    } else {
        // console.log("You are offline");
        alertify.notify("Opss..", "<div class='text-danger'>You just went offline. Kindly check your internet connection."); 
    }
}

$("#btnLogout").on('click', e => Logout());

var dt = new Date();
var s = dt.toLocaleDateString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' });
    s = s.split('/').reverse();
    // console.log(`${s[0]}-${s[2]}-${s[1]}`);
    $('[type="date"]').val(DateTime.now().toISODate());

$(window).on('resize', () => { 
    window.matchMedia("(max-width: 568px)").matches ? $("#carts button.active").addClass('withChevron') : $("#carts button.active").removeClass('withChevron');
});    

$('[type="search"]').val('');

// Dropdown hover effect
$(".dropdown").on("click", e => $(e.target).closest('button').find('.dropdown-menu').toggleClass('open'))

// Hide Dropdown menu when clicked outside
$(document).on('click', e => {
    if (!$(e.target).closest('.dropdown').length) {
        $('.dropdown-menu').removeClass('open');
    }
    if (!$(e.target).closest('header div:last-child').length) {
        $('header div:last-child menu, header div:last-child a:not(menu a) i').removeClass('open');
    }
}); 

$("header div:last-child a:not(menu a)").on('click', e => {
    $("header div:last-child menu, header div:last-child a:not(menu a) i").toggleClass('open');
});

$(document).on('click keydown keyup keypress', ".disabled", e => {
    e.preventDefault();
    return false;
});

const printTableData = async params => {
    // console.log("printTableData params: ", params)
    const { title, footer } = params
    setPrintHeader({
        table: params.table,
        content: `
            ${ await DOC_PRINT_HEADING({  }) } 
            ${title || `
                <div style="display: flex; justify-content: space-between; align-items: center; box-shadow: 0 3px 10px 0 rgba(0, 0, 0, .4);">
                    <section style="display: grid; grid-template-columns: auto auto; gap: 20px; align-items: center;">
                        <a href="javascript:void(0);" class="close no-udl clr-default" style="transform: scale(1.5); padding: 10px;" onclick="Notif.hide($('.notifyjs-crud-reports-base'));"><i class="lni lni-chevron-left"></i></a> 
                        <span style="text-overflow: ellipsis; overflow: hidden; whitespace: nowrap;">${title}</span>
                    </section>                                     
                    <button type="button" class="btn btn-default" id="btnExport"><i class="lni lni-share"></i></button>
                    <div class="search-pane form-group" style="width: 180px; margin: 5px;">
                        <input autofocus type="search" id="search_report" placeholder="search results" style="padding-right: 30px;">
                        <a href="javascript:void(0);" class="no-udl clr-inverse" onclick="$('#find_item').val('').focus(); $('#find_item').trigger('input');"><i class="lni lni-search-alt"></i></a>
                    </div>  
                </div>
            `}
        `
    });
    params.table.options.printFormatter = (tableHolderElement, tableElement) => $(tableHolderElement).append(params.footer)
    // .append(`<div style="display: flex; gap: 5px; align-items: center;">Printed by:<h3>${activeUser.name} @ ${DateTime.now().toLocaleString(DateTime.DATETIME_MED_WITH_WEEKDAY)}</h3></div>`)
    params.table.print("active", false, { columnGroups: true })
},
exportTableData = params => {
    params.table.download(params.type, params.fileName, params.opts)
};

let notifsData, notifs,
popNotifs = async params => {
    let { myStores } = params, req = await pop(`../notifs.php`, null);
    notifsData = {};

    // let noty = {}

    // _.map([ {title: 'openMR', cb: entry => entry.stat  == 'open'},  {title: 'pendingMR', cb: entry => entry.stat == 'pending'},  {title: 'openPO', cb: entry => entry.stat == 'open'},  {title: 'pendingPO', cb: entry => entry.stat == 'pending'},  {title: 'weekNewItems', cb: () => req.data.weekNewItems} ], n =>  notifsData[n.title] = _.filter(req.data[n.title], n.cb));
    // console.log(notifsData)
    // console.log({myStores}, myStores[0].store_id)
    // console.log(extractStockProps({ store_id: myStores[0].store_id, data: req.data.weekNewItems }))

    console.log("notifsData: ", notifsData)
    return notifsData;
},
checkNotifs = async () => {
    let allStores, myStores, privNotifs = [];
    
    await StoresList().then(stores => allStores = stores);

    myStores = _.filter(allStores, as => _.indexOf(JSON.parse(activeUser.stores), as.store_id) > -1 && as)

    // console.log(myStores);

    // let reQuery = await setInterval(async () => {
        popNotifs({ myStores })
        .then(data => {
            console.log(data);
            notifs = _.filter(_.map(data, entry => _.size(entry) > 0), entry => entry == true);
            // console.log(notifs);
            
            // $("header #btnShowNotifs #badge").text(_.size(notifs)).css({'background': _.size(notifs) > 0 ? 'red' : '#ccc', 'color': _.size(notifs) > 0 ? '#fff' : '', 'width': _.size(notifs) < 9 ? '15px' : '25px'});
            $("header #btnShowNotifs #badge").html(`<span class="floating circular ui red label">${_.size(notifs)}</span>`).css({'background': _.size(notifs) > 0 ? 'red' : '#ccc', 'color': _.size(notifs) > 0 ? '#fff' : '', 'width': _.size(notifs) < 9 ? '15px' : '25px'});
            // clearInterval(reQuery);
        });
    // }, 2000);
}
location.pathname != "/" && activeUser && checkNotifs();

$("#btnShowNotifs").on('click', async e => {
    let allStores, myStores;
    
    await StoresList().then(stores => allStores = stores);
    myStores = _.filter(allStores, as => _.indexOf(JSON.parse(activeUser.stores), as.store_id) > -1 && as)

    // console.log($("#overlay_notif #store_id").val(), myStores[0])

    if(!_.isUndefined(notifsData) && _.size(notifsData) > 0){
        // console.log(notifsData);
        Notif.show({
            el: $(e.target).closest('header'), 
            title: `
                <div id="overlay_notif">
                    <div style="display: flex; justify-content: space-between; align-items: center; border-bottom: solid 1px #eee;">
                        <small>Notifications [${_.size(notifs)}]</small>
                        <a href="javascript:void(0);" class="clr-inverse" onclick="$(event.target).closest('.notifyjs-wrapper').remove();"><i class="fa fa-times"></i></a>
                    </div>
                    <ul style="width: 300px; margin: 5px 15px; padding: 0;">
                        <li data-list="weekNewItems" style="padding: 10px 5px; border-bottom: solid 1px #ccc;">
                            <a href="javascript:void(0);" class="no-udl clr-inverse" style="display: flex; gap: 5px;">
                                <section>
                                    <span class="text-primary">${_.size(notifsData.weekNewItems)}</span> <b>New</b> Items 
                                </section>
                                <div class="form-group" style="margin: 0; height: 20px;">
                                    <div class="select-container" style="margin: 0; height: 20px;">
                                        <select name="store_id" id="store_id" required>
                                            ${_.join(_.split(_.map(myStores, (ms, i) => `<option value="${ms.store_id}">${_.startCase(ms.store)}</option>`), ','), '')}
                                        </select>
                                    </div>
                                </div> 
                            </a>
                        </li>
                        <li data-list="openMR" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.openMR)}</span> ${_.size(notifsData.openMR) > 1 ? `<b>MR's</b> are` : `<b>MR</b> is`} <b>OPEN</b>.</a></li>
                        <li data-list="pendingMR" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.pendingMR)}</span> ${_.size(notifsData.pendingMR) > 1 ? `<b>MR's</b> are` : `<b>MR</b> is`} pending <b>AUDIT</b>.</a></li>
                        <li data-list="openPO" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.openPO)}</span> ${_.size(notifsData.openPO) > 1 ? `<b>PO's</b> are` : `<b>PO</b> is`} <b>OPEN</b>.</a></li>
                        <li data-list="pendingPO" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.pendingPO)}</span> ${_.size(notifsData.pendingPO) > 1 ? `<b>PO's</b> are` : `<b>PO</b> is`} pending <b>AUDIT</b>.</a></li>
                        <li data-list="zeroStock" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.zeroStock)}</span> ${_.size(notifsData.zeroStock) > 1 ? 'items are' : 'item is'} out of stock.</a></li>
                        <li data-list="lowStock" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.lowStock)}</span> ${_.size(notifsData.lowStock) > 1 ? 'items are' : 'item is'} due for reorder.</a></li>
                        <li data-list="expiredStock" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><a href="javascript:void(0);" class="no-udl clr-inverse"><span class="text-primary">${_.size(notifsData.expiredStock)}</span> ${_.size(notifsData.expiredStock) > 1 ? 'items are' : 'item is'} due for expiry(ed).</a></li>
                    </ul>
                </div>
            `, 
            styleName: 'system-notifs',
            position: 'bottom right', 
            className: 'default',
            autoHide: false,
            clickToHide: false
        });
        let wrapper = $('.notifyjs-system-notifs-base').closest('.notifyjs-wrapper')
        wrapper
        .css({'position': 'fixed', 'right': 'calc(100vw + 30px)'})
        .find('.notifyjs-container').css({'width': '320px', 'height': '200px'})
        wrapper.find('.notifyjs-arrow').css({'left': 'calc(100vw - 65px)'})
    }
});

let notifDetailsTable;
const popNotifsData = params => {
    console.log({params})

    let { list, columns, initialSort, groupBy, groupHeader, cellClick, rowClick, rowSelectionChanged, printHeader} = params;

    Notif.show({
        el: params.target, 
        title: `
            <div id="overlay_notifDetails" style="width: 320px;">
                <div id="notif-line-details-table"></div>
            </div>
        `, 
        styleName: 'notif-line-details',
        position: 'bottom left', 
        className: 'info',
        autoHide: false,
        clickToHide: false
    });

    notifDetailsTable = new Tabulator(".notifyjs-notif-line-details-base #notif-line-details-table", {
        // width: '100vw',
        maxHeight: 450,
        // data: tabledata,           //load row data from array
        layout: "fitColumns",      //fit columns to width of table
        layoutColumnsOnNewData: true,
        // responsiveLayout: "hide",  
        selectable: 1,
        // movableColumns: true,      //allow column order to be changed
        resizableRows: false,       //allow row order to be changed
        // resizableColumns: false,
        // paginationSize: true,         //allow 7 rows per page of data
        initialSort,
        groupBy,
        groupHeader,
        // rowSelectionChanged,
        columnDefaults: {
            vertAlign: 'middle',
            tooltip: true
        },
        columns,
        // selectableCheck: row => !_.isUndefined(row.getData().item),
        // rowClick: (e, row) => alert(), 
        rowFormatter: row => {
            //row - row component for the selected row
            // console.log(row.getData().expdate)
        },
        // printFormatter: (tableHolderElement, tableElement) => {
            //tableHolderElement - The element that holds the header, footer and table elements
            //tableElement - The table
            // console.log(tableHolderElement)       
        // },
        placeholder: "No record found",
        footerElement: `<div style="display: grid; grid-template-columns: 1fr auto auto; gap: 10px; justify-content: space-between;">
                            <div class="search-pane float-xs" style="position: relative;">
                                <input type="search" id="filter_notif_table" placeholder="Search item...">
                                <label for="filter_notif_table" style="cursor: pointer;"><i class="lni lni-search-alt text-primary" style="width: 40px; height: 40px; display: flex; justify-content: center; align-items: center;"></i></label>
                            </div>
                            <button type="button" class="btn btn-default btn-sm" id="btnExportNotifData"><i class="lni lni-share text-primary"></i> Share</button>
                            <button type="button" class="btn btn-sm text-danger" onclick="$(event.target).closest('.notifyjs-wrapper').remove();">Close</button>
                        </div>
        `,
        printHeader
    });
    console.log(notifsData[list])
    notifDetailsTable.on('tableBuilt', () => {
        notifDetailsTable.setData(notifsData[list]);
    });

    notifDetailsTable.on('cellClick', (e, cell) => {
        cellClick(e, cell);
    });
}

$(document).on('click', ".notifyjs-system-notifs-base ul li a", async e => {   

    Notif.hide($('.notifyjs-notif-line-details-base'))   

    let list = $(e.target).closest('li').data('list'), columns = [], initialSort, groupBy, groupHeader, cellClick, rowClick, rowSelectionChanged,
    printHeader = `<div>
        <div style="display: grid; grid-template-columns: auto 1fr; justify-content: space-between;">
            <section><img src='../uploads/${companyProfile[0]['logo']}' alt='${companyProfile[0]['org_name']} Logo' width='100px' height='100px'></section>
            <section style="text-align: center;"><h1 style="margin: 10px 0; font-size: 33px;">${companyProfile[0]['org_name']}</h1><section style="margin-top: 0;"><b>LOC</b>: ${companyProfile[0]['addr']}</section><section style="margin-top: 5px;"><b>TEL</b>: ${companyProfile[0]['phone']} / ${companyProfile[0]['mobile']}</section><section></section></section>
        </div>
    `;

    // let allStores, myStores;
    
    // await StoresList().then(stores => allStores = stores);
    // myStores = _.filter(allStores, as => _.indexOf(JSON.parse(activeUser.stores), as.store_id) > -1 && as)

    if(list == "weekNewItems"){
        // console.log({myStores}, notifsData.weekNewItems)
        columns = [...columns, 
            // {title: "#", field:"", formatter: "rownum", width: 20},
            // {title: "DATE", field: "regdate", headerSort: false, hozAlign: 'right', formatter: "date", width: 50, download: false, visible: false, print: false },
            {title: "DESCRIPTION", field: "item", formatter: (cell, formatterParams, onRendered) => _.startCase(_.toLower(cell.getValue())) },
            // {title: "DURATION", field: "SINCE", formatter: (cell, formatterParams, onRendered) => `${cell.getValue() > 0 ? cell.getValue() : ``} days ago`, width: 100 },
            {title: 'PERIOD', field: 'SINCE', formatter: cell => RTF(cell.getValue()), width: 90 },
            // {title: 'DATE', field: 'REGDATE', }
            // {title: "PPQ", field: "stores", hozAlign: "right", formatter: 'money', bottomCalc: (values, data, bottomCalcParams) => currency(_.sumBy(values, entry => parseFloat(entry))).format({ symbol: '' }), width: 100 },
            // {title: "AMOUNT", field: "AMT", hozAlign: "right", formatter: 'money', bottomCalc: (values, data, bottomCalcParams) => currency(_.sumBy(values, entry => parseFloat(entry))).format({ symbol: '' }), width: 100 },
        ];
        initialSort = [             //set the initial sort order of the data
            {column: "regdate", dir: "desc"},
        ],
        // groupBy = ["req_date"];            
        // groupHeader = [
        //     (value, count, data, group) => value && `<span style="color: #222;">${DateTime.fromISO(value).toFormat('ccc, LLL dd, y')} <samp style="color: maroon;">(${count} ${count > 1 ? "MR's" : 'MR'})</samp></span>`
        // ],
        cellClick = (e, cell) => {
            // let col = _.toLower(cell.getField()), { mr_num } = cell.getData();
            // // console.log(mr_num);
            // if(col == "mr_num" || col == "issue"){
            //     // console.log(user.stock.view_mr)
            //     _.split(location.pathname, '/')[1] !== 'stock' ? location.href = `/stock?mr_num=${mr_num}` : $("#").trigger('click');
            // }
        }
        printHeader += `            
                <h3 class="txt-center" style="text-decoration: double dashed underline;">${_.size(notifsData.weekNewItems)} NEWLY CREATED ITEMS THIS WEEK</h3>
            </div>
        `;

        // e.target.id == "store_id" && 
        
        $(document).on('change', "#overlay_notif #store_id", e => {
            // $("#createStaff").hide()
            // popNotifsData({ target: $(e.target).closest('li'), list, columns, initialSort, groupBy, groupHeader, cellClick, rowClick, rowSelectionChanged, printHeader });
            $('li[data-list="weekNewItems"]').trigger('click')
        })
        
        // SHOW DATA
        e.target.id != "store_id" && popNotifsData({ target: $(e.target).closest('li'), list, columns, initialSort, groupBy, groupHeader, cellClick, rowClick, rowSelectionChanged, printHeader });
        
        // $("#overlay_notifDetails").prepend(`
        //     <div style="background: #fff;">
        //         <div class="form-group" style="margin: 0;">
        //             <div class="select-container">
        //                 <select name="store_id" id="store_id" required>
        //                     <option value="">--- select ---</option>
        //                     ${_.join(_.split(_.map(myStores, (ms, i) => `<option value="${ms.store_id}">${_.startCase(ms.store)}</option>`), ','), '')}
        //                 </select>
        //                 <label for="store_id" class="floated-up-lbl" style="top: -5px;">Select Store</label>
        //                 <sup class="required position-absolute" style="top: -17px;"><i class="lni text-danger fs-2">&ast;</i></sup>
        //             </div>
        //         </div> 
        //     </div> 
        // `);
        
    }
    else if(list == "openMR" || list == "pendingMR"){
        // console.log(user)
        if(user.stock.view_mr){            
            columns = [...columns, 
                // {title: "#", field:"", formatter: "rownum", width: 20},
                {title: "DATE", field: "regdate", headerSort: false, hozAlign: 'right', formatter: "date", width: 50, download: false, visible: false, print: false },
                // {title: "STATE", field: "stat", formatter: (cell, formatterParams, onRendered) => _.toUpper(cell.getValue()), width: 80 },
                {title: "MR #", field: "mr_num", formatter: (cell, formatterParams, onRendered) => `<a href="javascript:void(0);">${_.toUpper(cell.getValue())}</a>` },
                {title: "AMOUNT", field: "AMT", hozAlign: "right", formatter: 'money', bottomCalc: (values, data, bottomCalcParams) => currency(_.sumBy(values, entry => parseFloat(entry))).format({ symbol: '' }), width: 100 },
            ];
            initialSort = [             //set the initial sort order of the data
                {column: "regdate", dir: "desc"},
            ],
            groupBy = ["req_date"];            
            groupHeader = [
                (value, count, data) => value + `<span style='color:#d00; margin-left:10px;'>${DateTime.fromISO(value).toFormat('ccc, LLL dd, y')} <samp style="color: maroon;">(${count} ${count > 1 ? "MR's" : 'MR'})</samp></span>`,
            ],
            cellClick = (e, cell) => {
                let col = _.toLower(cell.getField()), { mr_num } = cell.getData();
                // console.log(mr_num);
                if(col == "mr_num" || col == "issue"){
                    // console.log(user.stock.view_mr)
                    _.split(location.pathname, '/')[1] !== 'stock' ? location.href = `/stock?mr_num=${mr_num}` : $("#").trigger('click');
                }
            }
            printHeader += `            
                    <h3 class="txt-center" style="text-decoration: double dashed underline;">ZERO / OUT OF STOCK REPORT</h3>
                </div>
            `;
            // SHOW DATA
            popNotifsData({ target: $(e.target).closest('li'), list, columns, initialSort, groupBy, groupHeader, cellClick, rowClick, rowSelectionChanged, printHeader });
        }
        else{
            Notif.show({ el: $(e.target), title: `<div class="txt-center"><small><i class="lni lni-warning fa-2x"></i><br/>You are not allowed to process MR.</small></div>`, className: 'error', styleName: 'access-denied-process-mr', position: 'bottom left', autoHide: true });
        }
    }
    else if(list == "openPO" || list == "pendingPO"){
        // console.log(user)
        if(user.stock.view_po){            
            columns = [...columns, 
                // {title: "#", field:"", formatter: "rownum", width: 20},
                {title: "DATE", field: "regdate", headerSort: false, hozAlign: 'right', formatter: "date", width: 50, download: false, visible: false, print: false },
                // {title: "STATE", field: "stat", formatter: (cell, formatterParams, onRendered) => _.toUpper(cell.getValue()), width: 80 },
                {title: "PO No.", field: "order_num", formatter: (cell, formatterParams, onRendered) => `<a href="javascript:void(0);">${_.toUpper(cell.getValue())}</a>` },
                {title: "AMOUNT", field: "AMT", hozAlign: "right", formatter: 'money', bottomCalc: (values, data, bottomCalcParams) => currency(_.sumBy(values, entry => parseFloat(entry))).format({ symbol: '' }), width: 100 },
            ];
            initialSort = [             //set the initial sort order of the data
                {column: "regdate", dir: "desc"},
            ],
            groupBy = ["regdate"];            
            groupHeader = [
                (value, count, data) => `<span style='color:#d00; margin-left:10px;'>${DateTime.fromISO(DateTime.fromSQL(value).toISODate()).toFormat("ccc, DD")} <samp style="color: maroon;">(${count} ${count > 1 ? "PO's" : 'PO'})</samp></span>`,
            ],
            cellClick = (e, cell) => {
                let col = _.toLower(cell.getField()), { order_num } = cell.getData();
                // console.log(mr_num);
                if(col == "order_num" || col == "issue"){
                    // console.log(user.stock.view_mr)
                    _.split(location.pathname, '/')[1] !== 'stock' ? location.href = `/stock?order_num=${mr_num}` : $("#").trigger('click');
                }
            }
            printHeader += `            
                    <h3 class="txt-center" style="text-decoration: double dashed underline;">ZERO / OUT OF STOCK REPORT</h3>
                </div>
            `;
            // SHOW DATA
            popNotifsData({ target: $(e.target).closest('li'), list, columns, initialSort, groupBy, groupHeader, cellClick, rowClick, rowSelectionChanged, printHeader });
        }
        else{
            Notif.show({ el: $(e.target), title: `<div class="txt-center"><small><i class="fa fa-warning fa-2x"></i><br/>You are not allowed to process MR.</small></div>`, className: 'error', styleName: 'access-denied-process-po', position: 'bottom left', autoHide: true });
        }
    }
    else if(list == "zeroStock"){
        columns = [...columns, 
            // {title:"#", field:"", formatter: "rownum", width: 20},
            {title:"DESCRIPTION", field: "item", formatter: (cell, formatterParams, onRendered) => cell.getValue() && `${cell.getData().dim > 1 && cell.getValue().toUpperCase() + ' X ' + cell.getData().dim || cell.getValue().toUpperCase()}` || "", },
            {title:"QTY", field: "qty", hozAlign: "right", formatter: 'money', formatterParams: { precision: 0 }, width: 55 }
        ];
        printHeader += `            
                <h3 class="txt-center" style="text-decoration: double dashed underline;">ZERO / OUT OF STOCK REPORT</h3>
            </div>
        `;
    }
    else if(list == "lowStock"){
        columns = [...columns, 
            // {title:"#", field:"", formatter: "rownum", width: 20},
            {title:"DESCRIPTION", field: "item", formatter: (cell, formatterParams, onRendered) => cell.getValue() && `${cell.getData().dim > 1 && cell.getValue().toUpperCase() + ' X ' + cell.getData().dim || cell.getValue().toUpperCase()}` || "", },
            {title:"QTY", field: "qty", hozAlign: "right", formatter: 'money', formatterParams: { precision: 0 }, width: 55 },
            {title:"REORDER", field: "restock", hozAlign: "right", formatter: 'money', formatterParams: { precision: 0 }, width: 55 }
        ];
        printHeader += `            
                <h3 class="txt-center" style="text-decoration: double underline;">STOCK DUE FOR REORDER REPORT</h3>
            </div>
        `;
    }
    else if(list == "expiredStock"){
        columns = [...columns, 
            // {title:"#", field:"", formatter: "rownum", width: 20},
            {title:"DESCRIPTION", field: "item", formatter: (cell, formatterParams, onRendered) => cell.getValue() && `${cell.getData().dim > 1 && cell.getValue().toUpperCase() + ' X ' + cell.getData().dim || cell.getValue().toUpperCase()}` || "", },
            // {title:"QTY", field: "qty", hozAlign: "right", formatter: 'money', formatterParams: { precision: 0 }, width: 55 },
            {title:"EXPIRY", field: "expdate", hozAlign: "right", formatter: 'datetimediff', formatterParams: { humanize: true, suffix: true }, width: 100 }
        ];
        printHeader += `            
                <h3 class="txt-center" style="text-decoration: double dashed underline;">DUE / EXPIRED STOCK REPORT</h3>
            </div>
        `;
    }    

    $(document).on('input', '.notifyjs-notif-line-details-base #filter_notif_table', e =>{
        let filters = _.map(notifDetailsTable.getColumns(), col => ({ field: col.getField(), type: "like", value: _.trim(e.target.value) }));
        notifDetailsTable.setFilter([
            // {},
            // Nested filter OR Object
            filters
        ]);
    });

    $(document).on('click', '.notifyjs-notif-line-details-base #btnExportNotifData', e =>{
        // $(e.target).find('.notifyjs-export-data-base').remove();
        !$("#overlay_notifExportOpts").is(':visible') ? Notif.show({
            el: $(e.target).closest('button'), 
            title: `<div id="overlay_notifExportOpts" style="margin: 5px 15px; padding: 0; display: grid;">
                        <a href="javascript:void(0);" class="no-udl clr-inverse" id="btnExportPrint" style="padding: 10px 5px; border-bottom: solid 1px #ccc;"><i class="lni lni-printer"></i> Print</a></li>
                        <a href="javascript:void(0);" class="no-udl text-success" id="btnExportExcel" style="padding: 10px 5px;"><i class="lni lni-layout"></i> Excel</a></li>
                    </div>
            `, 
            styleName: 'export-notif-data',
            position: 'top center', 
            className: 'default',
            autoHide: false,
            clickToHide: false
        }) : Notif.hide($('.notifyjs-export-notif-data-base'));

        $('.notifyjs-notif-line-details-base #btnExportPrint').on('click', e =>{
            notifDetailsTable.print();
        });
    
        $('.notifyjs-notif-line-details-base #btnExportExcel').on('click', e =>{
            notifDetailsTable.download("xlsx", "data.xlsx", {sheetName: "MyData"});
        });
    });


});

$("#btnHelp").on('click', e => {
    $('menu').removeClass('open');
    Notif.show({
        el: $(e.target).closest('header'), 
        title: `
            <div style="width: calc(100vw - 10px); height: 400px;">

            </div>
        `, 
        styleName: 'app-help',
        position: 'bottom right', 
        className: 'default',
        autoHide: false,
        clickToHide: false
    });
});

$("header div:last-child menu section:first-child img").on('click', e => {
    let pinCode = _.toNumber(prompt("Change Passcode"));
    // console.log(String(pinCode), _.isNumber(pinCode))
    if(!_.isNull(pinCode)){
        if(_.isNumber(pinCode) && _.size(String(pinCode)) == 6){
            $.post(`/staff/crud.php?update&changePin`, { pin: pinCode, emp_id: activeUser.id }, resp => {
                if(resp.updated){
                    appSounds.oringz.play();
                    alertify.success("Your Passcode updated successfully.");
                    myAlertfyDialog({ 
                        name: 'accountChange',
                        content: `
                            <div style="display: grid: justify-content: space-between; align-items: center;">
                                <div class="txt-center" style="width: 400px; height: 200px; margin: auto auto;">
                                    <h3 class="text-success">Account Updated!</h3>
                                    <h5>You will be redirected to login!</h5>
                                    <p><i class="fa fa-spinner fa-spin fa-2x"></i></p>
                                </div>
                            </div>
                        `,
                        setup: {
                            closable: false
                        }
                    });
                    setTimeout(() => {
                        Logout();
                    }, 3000);
                }
                else
                    console.log(resp);
            }, 'json');
        }
        else{
            alert(`Invalid entry. Please try again.\n\nPasscode must be 6 numbers in length.`);
        }
    }
});



/* ************                     ************ 
                    SHARED_CODE
/* ************                     ************ */

// EXPAND COLLAPSIBLE SEARCHBAR
$(document).on('input focus keydown', 'input[type="search"]', e => {
    // console.log(e.target);
    if(window.matchMedia("(max-width: 500px)").matches && $(e.target).closest('.search-pane').hasClass('float-xs') && !$('.search-pane').hasClass('open') && !$(e.target).is(':disabled')){
        $(e.target).closest('.search-pane.float-xs').addClass('open');
        // $('.ajax-page.open').removeClass('open');
    }
});

$(document).on('blur', 'input[type="search"]', e => $(e.target).closest('.search-pane').find('label').click());

$(document).on('click', '.search-pane label', e => $('.search-pane').hasClass('open') && $('.search-pane input[type="search"]').prop('disabled', true) && $('.search-pane').removeClass('open') && setTimeout(() => $('.search-pane input[type="search"]').prop('disabled', false), 1) || $(e.target).closest('.search-pane.float-xs').addClass('open'));

export {
    // TextEditor
    companyProfile,
    staffBioData,
    printTableData,
    exportTableData,
    checkUserRights, 
    AccessRights, 
    checkNotifs,
    popNotifsData,
    Logout
}